  IF OBJECT_ID('P_ATUALIZA_SALDO_FIDELIDADE') IS NOT NULL
    BEGIN
        DROP PROCEDURE P_ATUALIZA_SALDO_FIDELIDADE;
END;
GO

--EXECUTE P_ATUALIZA_SALDO_FIDELIDADE
CREATE PROCEDURE P_ATUALIZA_SALDO_FIDELIDADE
WITH ENCRYPTION AS
SET NOCOUNT ON;
     DECLARE @CD_EMP INT;
     DECLARE @CD_CLI INT;
     DECLARE @QTDE_PONTOS MONEY;
     CREATE TABLE #RC_CLI_PONTOS
     (CD_EMP      INT,
      CD_CLI      INT,
      QTDE_PONTOS MONEY
     );

	print 'P_ATUALIZA_SALDO_FIDELIDADE - INSERT 1 ' + CONVERT(VARCHAR, GETDATE(), 108);
     INSERT INTO #RC_CLI_PONTOS
          SELECT a.CD_EMP,
                   a.CD_CLI,
                   ROUND(ISNULL(c.CREDITO, 0),2) - ROUND(ISNULL(d.DEBITO, 0),2)
            FROM RC_CLI a
                 LEFT JOIN
            (
                SELECT CD_CLI,
                       CREDITO = SUM(ROUND(QTDE_PONTOS,2))
                FROM RC_CLI_FIDELI_PONTOS_CREDITO
                GROUP BY CD_CLI
            ) c ON c.CD_CLI = a.CD_CLI
                 LEFT JOIN
            (
                SELECT CD_CLI,
                       DEBITO =SUM(ROUND(QTDE_PONTOS,2))
                FROM RC_CLI_FIDELI_PONTOS_DEBITO
                GROUP BY CD_CLI
            ) d ON d.CD_CLI = a.CD_CLI
            WHERE a.TP_CONS_FINAL <> 1
                  AND a.CONS_FINAL <> 1
                  AND a.CD_EMP = 1
                  AND ROUND(ISNULL(a.QTDE_PONTOS, 0),2) <> (ROUND(ISNULL(c.CREDITO, 0),2) - ROUND(ISNULL(d.DEBITO, 0),2));

--Atualizando o saldo de pontos dos clientes
--foi criado um cursor para nao travar os demais usuarios do sistema
--pois estaremos atualizando linha a linha
     SET NOCOUNT ON;
	
	print 'SELECT 2 ' + CONVERT(VARCHAR, GETDATE(), 108);
     DECLARE Clientes CURSOR FAST_FORWARD
     FOR
         SELECT DISTINCT
                CD_EMP,
                CD_CLI,
                QTDE_PONTOS
         FROM #RC_CLI_PONTOS;
     OPEN Clientes;
     FETCH NEXT FROM Clientes INTO @CD_EMP, @CD_CLI, @QTDE_PONTOS;
     WHILE @@FETCH_STATUS = 0
         BEGIN
             print 'UPDATE 3 ' + CONVERT(VARCHAR, GETDATE(), 108);
             UPDATE RC_CLI
               SET
                   QTDE_PONTOS = @QTDE_PONTOS
             WHERE CD_EMP = @CD_EMP
                   AND CD_CLI = @CD_CLI;
				   
		--Proximo registro
             FETCH NEXT FROM Clientes INTO @CD_EMP, @CD_CLI, @QTDE_PONTOS;
         END;
	
	
--Fechando cursos
     CLOSE Clientes;
--Desalocando cursos da memoria
     DEALLOCATE Clientes;
     DROP TABLE #RC_CLI_PONTOS;

PRINT 'P_ATUALIZA_SALDO_FIDELIDADE FINALIZADA!';